<?php
$teams = [
    [
        'id'=>'tom-wilson',
        'name' => 'Tom Wilson',
        'title' => 'Acquisitions, Development, Investments ',
        'description' => 'With a 25+ year track record as a serial telecom entrepreneur, Wilson successfully launched, capitalized, and exited multiple telecom ventures, leading several Series A rounds and developing high-performance investment strategies. His experience includes building and managing telecom data centers and over 11,000 km of fiber infrastructure across the U.S., Asia, the Middle East, and Africa. As CEO of a 4G LTE carrier in the South Pacific and founder of industry-wide advocacy councils across SEA, SAARC, and MEA, he led large-scale infrastructure projects and regulatory policy engagement. Tom brings deep expertise in global partnerships, cross-border team leadership, and capital deployment—offering investors a seasoned, execution-focused partner for AI data center acquisition and development.',
        'image' => 'tom-wilson-lg.webp'
    ],
    [
        'id'=>'carol-pepper',
        'name' => 'Carol Pepper',
        'title' => 'Corporate Finance & Investments Management',
        'description' => 'Carol has over 30 years of experience as a CEO, CIO and CFO. She has acted as an External Chief Investment Officer for Single Family Offices globally, and has supervised over $7 Billion of Family Office assets during the last 24 years. Pepper International was named Best Global Boutique by STEP, the Society of Trust and Estate Planners, and Carol was named a Global Power Women, Top Private Wealth CEO and Top 20 Family Office Advisor globally. Before Pepper International, Carol was a Senior Portfolio Manager for the Rockefeller Family Office, managing over $1 Billion. Prior to the Rockefeller Family Office, she was a Member of Senior Management at Credit Suisse, a Principal at Morgan Stanley, and a Vice President at JP Morgan Private Bank and Citibank. She  has managed M&A, Corporate Finance and Family Office transactions and portfolios.',
        'image' => 'carol-pepper-lg.webp'
    ],
    [
        'id'=>'riad-hartani',
        'name' => 'Riad Hartani',
        'title' => 'Ph.D. Technology & Due Diligence',
        'description' => 'Dr. Riad Hartani has spent the last 25 years deploying digital and internet infrastructure at scale, post his Ph.D. in Artificial Intelligence. In particular, he has worked with over 30 of the world’s largest data center, cloud and telecom operators and investors, spanning all aspects of the deployment lifecycle, including due diligence, funding, designing, operating and scaling business to global markets.',
        'image' => 'Riad-Hartani.jpg'
    ],
     [
         'id' => 'vatche-sarkoyan',
        'name' => 'Vatche Sarkoyan',
        'title' => 'Contract Management & Mechanical Engineering',
        'description' => '40+ years of experience in all aspects of design, build, contracting, mechanical, and strategic business development. He has built ten Data Centers (IBM, Equinox, etc.) and over 35 hotels/casinos—including many of the major properties on the Las Vegas strip—along with many major hospitals, clean rooms, high-residential towers, and office buildings. Vatche earned his degree in Engineering at California State Polytechnic University, Pomona and founded S3H, a mechanical engineering and construction company, in 2005 which he continues to lead today.',
        'image' => 'Vatche-Sarkoyan.jpg'
    ],
     [
         'id' => 'summer-harriff',
        'name' => 'Summer Harriff, Ph.D.',
        'title' => 'Investment Management',
        'description' => '25+ years of leadership experience in the Life Sciences and Healthcare sectors, most often holding the position of President, COO. Summer helps translate corporate vision into strategy and tactics and to align human, technology, and financial resources with business goals and objectives. Summer has helped over 40 startups commercialize successfully by helping to secure funding, navigate and comply with regulations, and scale the business. She has also led large-scale change and technology adoption for clients and assisted clients with data center validation and transitions.',
        'image' => 'Summer-Harriff.webp'
    ],
     [
         'id' => 'venkat-thummisi',
        'name' => 'Venkat Thummisi',
        'title' => 'Digital Infrastructure & AI Systems',
        'description' => 'Venkat Thummisi is a veteran of digital infrastructure with a career spanning more than two decades at the intersection of datacenters, high-performance computing, and AI systems. Over the last four years at OpenAI, he led the core infrastructure that enabled the training and deployment of frontier AI models. His work involved designing GPU-dense clusters optimized for low-latency interconnects, fine-tuned power and cooling topologies for hyperscale efficiency, and next-generation storage architectures to sustain the massive throughput requirements of large language models. <br><br>Venkat’s contributions at OpenAI directly advanced the ability to train multi-trillion-parameter models with reliability, speed, and cost efficiency at global scale. Prior to OpenAI, Venkat spent more than 20 years at EMC (now Dell Technologies), where he built over a dozen enterprise-grade datacenters totaling more than 2.5 GW of capacity across North America, Europe, and Asia. He pioneered architectures that combined replication, mirroring, and high-availability frameworks to guarantee business continuity for mission-critical workloads in banking, telecom, and healthcare. His designs consistently pushed the boundaries of redundancy and fault tolerance, setting benchmarks for Tier III and Tier IV resilience while also driving advancements in energy efficiency and modular datacenter deployments.
  <br><br>Extending his expertise into healthcare, Venkat led the design of secure, cloud-based infrastructure for Trizetto (later acquired by Cognizant). He built HIPAA-compliant environments capable of supporting millions of transactions per day across payer platforms, integrating advanced encryption, zero-trust network segmentation, and elastic compute layers to meet both regulatory and performance demands.
',
        'image' => 'venkat-thummisi.webp'
    ]
];
$teamId = $_GET['team'] ?? null;
$team = null;

foreach ($teams as $t) {
    if ($t['id'] === $teamId) {
        $team = $t;
        break;
    }
}
    
$pageTitle = $team['name'] . " | Trionic Capital Partners";
$Des = $team['title'];
$ogDes = $team['description'];
$ogUrl = "https://www.trioniccapitalpartners.com/team-profile?team=". $team['id'];
include '_header.php'; ?>
<div id="smooth-wrapper">
    <div id="smooth-content">
        <main>

                <!-- breadcrumb-section -->
                <section class="breadcrumb-section__area heading-bg">
                    <div class="breadcrumb-section__wrapper" data-background="assets/img/banner/breadcrumb-bg-thumb.jpg">
                        <div class="container">
                            <div class="breadcrumb-section__content text_center breadcrumb-section__space">
                                <h3 class="breadcrumb-section__title">Team Profile</h3>
                                <ul class="breadcrumb-section__page">
                                    <li>Experienced Leaders Driving AI Infrastructure</li>
                                </ul>
                            </div>
                        </div>
                        <div class="breadcrumb-section__border"></div>
                    </div>
                </section>
                <?php if($team) {?>
                <!-- team-details -->
                <section class="team-details__area section-space fade-wrapper mb-50">
                    <div class="container">
                        <div class="row align-items-center">
                            <div class="col-lg-6">
                                <div class="team-details__thumb">
                                    <img class="img-custom-anim-img" src="assets/img/team/<?php echo $team['image'] ; ?>" alt="image not found">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="team-details__info">
                                    <div class="section-heading__wrap mb-15">
                                        <span class="section__subtitle rr-title-anim mb-15"><?php echo $team['title'] ; ?></span>
                                        <h3 class="section__title rr-title-anim"><?php echo $team['name'] ; ?></h3>
                                    </div>
                                    <div class="fade-top">
                                        <p class="team-details__dec mb-30"><?php echo $team['description'] ; ?></p>
                                    </div>
                                    <!--<div class="fade-top">-->
                                    <!--    <p class="team-details__dec mb-45">Whether it’s implementing a new CRM, streamlining campaign, or integrating AI tools into daily operations—he ensures-->
                                    <!--    every digital system works for the business</p>-->
                                    <!--</div>-->
                                    <!--<div class="team-details__social fade-top">-->
                                    <!--    <span>Portfolio:</span>-->
                                    <!--    <div class="social_link">-->
                                    <!--        <a href="https://www.behance.net/">BEHANCE</a>-->
                                    <!--        <a href="http://www.dribbble.com/">DRIBBBLE</a>-->
                                    <!--        <a href="https://www.instagram.com/">INSTAGRAM</a>-->
                                    <!--    </div>-->
                                    <!--</div>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                
                <?php } ?>

            </main>
            <!-- Footer area start -->
       <?php include '_footer.php'; ?>